#!/bin/bash
# 1Panel 第三方应用商店同步脚本（轻量优化版）
# 仅同步应用，不执行镜像替换

# 启用严格模式：遇到错误、未定义变量、管道错误时立即退出
set -euo pipefail

# 设置字段分隔符，防止文件名含空格或换行符时出错
IFS=$'\n\t'

# 配置路径
GIT_REPO="https://cnb.cool/gyhwd.top/1panel-appstore"  # 第三方应用商店地址
TMP_DIR="/opt/1panel/resource/apps/local/appstore-localApps"
LOCAL_APPS_DIR="/opt/1panel/resource/apps/local"

# 确保脚本退出时自动清理临时目录（即使中途出错也会执行）
# trap 'rm -rf "$TMP_DIR"' EXIT
trap 'echo "🧹 清理临时目录: $TMP_DIR"; rm -rf "$TMP_DIR"' EXIT

# 开始克隆应用商店仓库
echo "📥 Cloning appstore repo..."
git clone "$GIT_REPO" "$TMP_DIR"

# 创建本地应用目录（如果不存在）
mkdir -p "$LOCAL_APPS_DIR"

# 遍历所有应用并同步到本地
for app_path in "$TMP_DIR/apps/"*; do
    # 跳过非目录项
    [ -d "$app_path" ] || continue

    app_name=$(basename "$app_path")
    local_app_path="$LOCAL_APPS_DIR/$app_name"

    echo "🔁 Updating app: $app_name"
    # 如果本地已存在同名应用，先删除
    [ -d "$local_app_path" ] && rm -rf "$local_app_path"
    # 复制新版本应用
    cp -r "$app_path" "$local_app_path"
done

echo "✅ Sync completed."